<?
/* CONFIGURABLE SETTINGS */

$input = 'file.nfo';	// The file name of the file that will be converted
$white_r = 255;		// Red,Green,Blue components of the background color
$white_g = 255;
$white_b = 255;
$black_r = 0;	// Red,Green,Blue components of the write color
$black_g = 0;
$black_b = 0;
$forcelinelength = 0;	// Force length of all lines to a value, 0 to disable

$cache_image = 86400;	// Cache image on user side for n seconds, 0 to disable
/* END OF CONFIGURABLE SETTINGS */

$output = '';
$letters = NULL;
init_letters();
create_png_table();

$handle = fopen($input,'rb');
if ($handle==FALSE) die();
$contents = fread($handle,filesize($input));
fclose($handle);
$contents = str_replace(chr(13),chr(10),$contents);
$contents = str_replace(chr(10).chr(10),chr(10),$contents);

$lines = explode(chr(10),$contents);
unset($contents); // contents of nfo file is no longer needed, free memory

$linecount = count($lines);
if ($linecount<1) 
{ $lines = array();
	$lines[0]= ' ';
	$linecount=1;
}
$linelength=1;

for ($i=0;$i<$linecount;$i++)
{ $len = strlen($lines[$i]);
	if ($len > $linelength) $linelength = $len;
}
if ($forcelinelength!=0) $linelength = $forcelinelength;
for ($i=0;$i<$linecount;$i++)
{
 	$len = strlen($lines[$i]);
 	if ($len < $linelength) $lines[$i].= str_repeat(' ',$linelength - $len);
}

$img_width = 8 * $linelength;  // number of characters * 8 pixels/character/width
$img_height = 12 * $linecount; // number of characters * 12 pixels/character/height
$img_data = pack('c*',0x78,0x01); // start of zlib datastream
$img_datastream = '';
for ($lineindex=0;$lineindex < $linecount;$lineindex++)
{
	$buffer ='';
	for ($j=0;$j<12;$j++)
	{
		$linebuffer='';
		for ($i=0;$i < $linelength;$i++)
		{
			$charcode = ord($lines[$lineindex]{$i});
			$linebuffer .= chr($letters[$charcode][$j]);
		}
		$buffer .= chr(0).$linebuffer; // in png format each scanline has 1 byte filter data, set to 0
	}
	// start of deflate block 
	// blocktype = 1 means this is the last block in the deflate datastream
	$blocktype = 0;
	if ($lineindex==($linecount-1)) $blocktype =1;
	$len = strlen($buffer);
	$img_data .= pack("c*",$blocktype, $len & 255,($len >> 8) & 255, 255 - ($len & 255), 255 - (($len >> 8) & 255));
	$img_data .= $buffer;
	// the raw byte stream is needed at the end to compute the Adler32 CRC of the image
	$img_datastream .= $buffer;
}

$output = '';

/* PNG Signature
   See http://www.libpng.org/pub/png/spec/1.0/PNG-Rationale.html#R.PNG-file-signature
   for details.
*/
$output .= pack("c*", 137,80,78,71,13,10,26,10);

/* PNG Header

Bytes Used For          Possible Values

4     Image Width       1 - 2^32-1
4     Image Height      1 - 2^32-1
1     Bit Depth         see chart below
1     Color Type        see chart below
1     Filter Method     0 - no filtering 1 - default filtering 
1     Interlace Method  0 - no interlacing 1 - Adam7 interlacing

Color Type | Allowed Bit Depths   Interpretation
           | 
   0       | 1,2,4,8,16            Each pixel is a grayscale sample.
   2       | 8,16                  Each pixel is an R,G,B triple.
   3       | 1,2,4,8               Each pixel is a palette index; a PLTE chunk must appear.
   4       | 8,16                  Each pixel is a grayscale sample, followed by an alpha sample.
   6       | 8,16                  Each pixel is an R,G,B triple, followed by an alpha sample.
                                  
*/                       

$data = pack("c*", 
($img_width >> 24) & 255,
($img_width >> 16) & 255,
($img_width >> 8) & 255,
$img_width & 255,
($img_height >> 24) & 255,
($img_height >> 16) & 255,
($img_height >> 8) & 255,
$img_height & 255,
1, 3, 0, 0, 0);
$output .= png_chunk('IHDR');
/* PNG Palette

The PLTE chunk contains from 1 to 256 palette entries, each a three-byte series 
of the form:
   Red:   1 byte (0 = black, 255 = red)
   Green: 1 byte (0 = black, 255 = green)
   Blue:  1 byte (0 = black, 255 = blue)
The number of entries is determined from the chunk length. 
A chunk length not divisible by 3 is an error.
For color type 3 (indexed color), the PLTE chunk is required.

See for more details: http://www.libpng.org/pub/png/spec/1.0/PNG-Chunks.html#C.PLTE

*/

$data = chr($white_r).chr($white_g).chr($white_b).
				chr($black_r).chr($black_g).chr($black_b);
$output .= png_chunk('PLTE');

/* PNG Data Stream

The datastream is formed from one or several IDAT chunks. If more than one chunk
is used, all chunks MUST be one after the other in the file.

IDAT Format:

4 bytes - Data Length
4 bytes - IDAT
n bytes - Data 
4 bytes - CRC

All the data inside the IDAT chunks is one ZLIB (Deflate) datastream,
which has the following format:

2 Bytes - Compression Method and Flags
n Bytes - One or several Blocks
4 Bytes - Adler32 CRC of the data INSIDE the blocks

Compression Method and Flags - See RFC1950 2.2 http://www.faqs.org/rfcs/rfc1950.html

A block containing uncompressed data has the following format:

1 byte  - flags. If set to 1, it is the last block
2 bytes - data length
2 bytes - data length complement
n bytes - the actual data 

See RFC 1951 3.2.4 for more info: http://www.faqs.org/rfcs/rfc1951.html
*/

$adata = $img_data;

$adler = adler32($img_datastream);
$adata .= chr(($adler >> 24) & 255);
$adata .= chr(($adler >> 16) & 255);
$adata .= chr(($adler >> 8) & 255);
$adata .= chr($adler & 255);

$data_toprocess = strlen($adata);
$offset = 0;
while ($data_toprocess>0)
{
	$data = substr($adata,$offset,($data_toprocess>8192)? 8192 : $data_toprocess);
	$output .=png_chunk('IDAT');
	$offset = $offset +8192;
	$data_toprocess = $data_toprocess-8192;
}

$data = '';
$output .= png_chunk('IEND');
header('Content-Type: image/png');
if ($cache_image!=0)
{
header("Expires: ".date("D, j M Y H:i:s", time() + $cache_image)." UTC");
header("Cache-Control: Public");
header("Pragma: Public");
}
echo $output;
die();

function create_png_table()
{
	global $crc_table;
	$z = -306674912; // = 0xedb88320
	for ($n = 0; $n < 256; $n++) 
	{
		$c = $n;
		for ($k = 0; $k < 8; $k++) 
		{
			$c2 = ($c >> 1) & 0x7fffffff;
			if ($c & 1) 
				$c = $z ^ ($c2);
			else 
				$c = $c2;
		}
		$crc_table[$n] = $c;
	}
}

function png_chunk($type)
{
  global $result, $crc_table,$data;

  // chunk layout:
  // length: 4 bytes: counting chunk data only
  // chunk type: 4 bytes
  // chunk data: length bytes
  // CRC: 4 bytes: CRC-32 checksum of the type and the data
  
  // copy data and create CRC checksum
  $len = strlen($data);
  $chunk = pack("c*", ($len >> 24) & 255,
          ($len >> 16) & 255,
          ($len >> 8) & 255,
          $len & 255);
  $chunk .= $type;
  $chunk .= $data;

  // calculate a CRC checksum with the bytes chunk[4..len-1]
  $z = 16777215;
  $z |= 255 << 24;
  $c = $z;
  for ($n = 4; $n < strlen($chunk); $n++) 
  {
   $c8 = ($c >> 8) & 0xffffff;
   $c = $crc_table[($c ^ ord($chunk[$n])) & 0xff] ^ $c8;
  }
  $crc = $c ^ $z;

  $chunk .= chr(($crc >> 24) & 255);
  $chunk .= chr(($crc >> 16) & 255);
  $chunk .= chr(($crc >> 8) & 255);
  $chunk .= chr($crc & 255);

  // add it to the result
  return $chunk;
}

function adler32($data,$offset=0)
{
	$s1 = 1;
	$s2 = 0;
	$len = strlen($data);
	for ($n = $offset; $n < $len; $n++) 
	{
        $s1 = ($s1 + ord($data[$n])) % 65521;
        $s2 = ($s2 + $s1) % 65521;
	}
	$adler = ($s2 << 16) | $s1;
	return $adler;
}

function init_letters()
{
global $letters;
$letters = array();
$letters[0] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[1] = array( 0, 126, 195, 129, 165, 129, 189, 153, 195, 126, 0, 0);
$letters[2] = array( 0, 126, 255, 255, 219, 255, 195, 231, 255, 126, 0, 0);
$letters[3] = array( 0, 0, 68, 238, 254, 254, 254, 124, 56, 16, 0, 0);
$letters[4] = array( 0, 16, 56, 124, 254, 254, 124, 56, 16, 0, 0, 0);
$letters[5] = array( 0, 24, 60, 60, 255, 231, 231, 24, 24, 126, 0, 0);
$letters[6] = array( 0, 24, 60, 126, 255, 255, 126, 24, 24, 126, 0, 0);
$letters[7] = array( 0, 0, 0, 0, 60, 126, 126, 60, 0, 0, 0, 0);
$letters[8] = array( 255, 255, 255, 255, 195, 129, 129, 195, 255, 255, 255, 255);
$letters[9] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[10] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[11] = array( 0, 62, 14, 58, 114, 248, 204, 204, 204, 120, 0, 0);
$letters[12] = array( 0, 60, 102, 102, 102, 60, 24, 126, 24, 24, 0, 0);
$letters[13] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[14] = array( 0, 127, 99, 127, 99, 99, 99, 103, 231, 230, 192, 0);
$letters[15] = array( 0, 0, 24, 219, 126, 231, 231, 126, 219, 24, 0, 0);
$letters[16] = array( 0, 128, 192, 224, 248, 254, 248, 224, 192, 128, 0, 0);
$letters[17] = array( 0, 2, 6, 14, 62, 254, 62, 14, 6, 2, 0, 0);
$letters[18] = array( 0, 24, 60, 126, 24, 24, 24, 126, 60, 24, 0, 0);
$letters[19] = array( 0, 102, 102, 102, 102, 102, 0, 0, 102, 102, 0, 0);
$letters[20] = array( 0, 127, 219, 219, 219, 123, 27, 27, 27, 27, 0, 0);
$letters[21] = array( 0, 126, 99, 48, 60, 102, 102, 60, 12, 198, 126, 0);
$letters[22] = array( 0, 0, 0, 0, 0, 0, 0, 254, 254, 254, 0, 0);
$letters[23] = array( 0, 24, 60, 126, 24, 24, 24, 126, 60, 24, 126, 0);
$letters[24] = array( 0, 24, 60, 126, 24, 24, 24, 24, 24, 24, 0, 0);
$letters[25] = array( 0, 24, 24, 24, 24, 24, 24, 126, 60, 24, 0, 0);
$letters[26] = array( 0, 0, 0, 24, 12, 254, 12, 24, 0, 0, 0, 0);
$letters[27] = array( 0, 0, 0, 48, 96, 254, 96, 48, 0, 0, 0, 0);
$letters[28] = array( 0, 0, 0, 0, 192, 192, 192, 254, 0, 0, 0, 0);
$letters[29] = array( 0, 0, 0, 36, 102, 255, 102, 36, 0, 0, 0, 0);
$letters[30] = array( 0, 0, 16, 16, 56, 56, 124, 124, 254, 254, 0, 0);
$letters[31] = array( 0, 0, 254, 254, 124, 124, 56, 56, 16, 16, 0, 0);
$letters[32] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[33] = array( 0, 48, 120, 120, 120, 48, 48, 0, 48, 48, 0, 0);
$letters[34] = array( 0, 102, 102, 102, 36, 0, 0, 0, 0, 0, 0, 0);
$letters[35] = array( 0, 108, 108, 254, 108, 108, 108, 254, 108, 108, 0, 0);
$letters[36] = array( 48, 48, 124, 192, 192, 120, 12, 12, 248, 48, 48, 0);
$letters[37] = array( 0, 0, 0, 196, 204, 24, 48, 96, 204, 140, 0, 0);
$letters[38] = array( 0, 112, 216, 216, 112, 250, 222, 204, 220, 118, 0, 0);
$letters[39] = array( 0, 48, 48, 48, 96, 0, 0, 0, 0, 0, 0, 0);
$letters[40] = array( 0, 12, 24, 48, 96, 96, 96, 48, 24, 12, 0, 0);
$letters[41] = array( 0, 96, 48, 24, 12, 12, 12, 24, 48, 96, 0, 0);
$letters[42] = array( 0, 0, 0, 102, 60, 255, 60, 102, 0, 0, 0, 0);
$letters[43] = array( 0, 0, 0, 24, 24, 126, 24, 24, 0, 0, 0, 0);
$letters[44] = array( 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 96, 0);
$letters[45] = array( 0, 0, 0, 0, 0, 254, 0, 0, 0, 0, 0, 0);
$letters[46] = array( 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 0, 0);
$letters[47] = array( 0, 0, 2, 6, 12, 24, 48, 96, 192, 128, 0, 0);
$letters[48] = array( 0, 124, 198, 206, 222, 214, 246, 230, 198, 124, 0, 0);
$letters[49] = array( 0, 16, 48, 240, 48, 48, 48, 48, 48, 252, 0, 0);
$letters[50] = array( 0, 120, 204, 204, 12, 24, 48, 96, 204, 252, 0, 0);
$letters[51] = array( 0, 120, 204, 12, 12, 56, 12, 12, 204, 120, 0, 0);
$letters[52] = array( 0, 12, 28, 60, 108, 204, 254, 12, 12, 30, 0, 0);
$letters[53] = array( 0, 252, 192, 192, 192, 248, 12, 12, 204, 120, 0, 0);
$letters[54] = array( 0, 56, 96, 192, 192, 248, 204, 204, 204, 120, 0, 0);
$letters[55] = array( 0, 254, 198, 198, 6, 12, 24, 48, 48, 48, 0, 0);
$letters[56] = array( 0, 120, 204, 204, 236, 120, 220, 204, 204, 120, 0, 0);
$letters[57] = array( 0, 120, 204, 204, 204, 124, 24, 24, 48, 112, 0, 0);
$letters[58] = array( 0, 0, 0, 56, 56, 0, 0, 56, 56, 0, 0, 0);
$letters[59] = array( 0, 0, 0, 56, 56, 0, 0, 56, 56, 24, 48, 0);
$letters[60] = array( 0, 12, 24, 48, 96, 192, 96, 48, 24, 12, 0, 0);
$letters[61] = array( 0, 0, 0, 0, 126, 0, 126, 0, 0, 0, 0, 0);
$letters[62] = array( 0, 96, 48, 24, 12, 6, 12, 24, 48, 96, 0, 0);
$letters[63] = array( 0, 120, 204, 12, 24, 48, 48, 0, 48, 48, 0, 0);
$letters[64] = array( 0, 124, 198, 198, 222, 222, 222, 192, 192, 124, 0, 0);
$letters[65] = array( 0, 48, 120, 204, 204, 204, 252, 204, 204, 204, 0, 0);
$letters[66] = array( 0, 252, 102, 102, 102, 124, 102, 102, 102, 252, 0, 0);
$letters[67] = array( 0, 60, 102, 198, 192, 192, 192, 198, 102, 60, 0, 0);
$letters[68] = array( 0, 248, 108, 102, 102, 102, 102, 102, 108, 248, 0, 0);
$letters[69] = array( 0, 254, 98, 96, 100, 124, 100, 96, 98, 254, 0, 0);
$letters[70] = array( 0, 254, 102, 98, 100, 124, 100, 96, 96, 240, 0, 0);
$letters[71] = array( 0, 60, 102, 198, 192, 192, 206, 198, 102, 62, 0, 0);
$letters[72] = array( 0, 204, 204, 204, 204, 252, 204, 204, 204, 204, 0, 0);
$letters[73] = array( 0, 120, 48, 48, 48, 48, 48, 48, 48, 120, 0, 0);
$letters[74] = array( 0, 30, 12, 12, 12, 12, 204, 204, 204, 120, 0, 0);
$letters[75] = array( 0, 230, 102, 108, 108, 120, 108, 108, 102, 230, 0, 0);
$letters[76] = array( 0, 240, 96, 96, 96, 96, 98, 102, 102, 254, 0, 0);
$letters[77] = array( 0, 198, 238, 254, 254, 214, 198, 198, 198, 198, 0, 0);
$letters[78] = array( 0, 198, 198, 230, 246, 254, 222, 206, 198, 198, 0, 0);
$letters[79] = array( 0, 56, 108, 198, 198, 198, 198, 198, 108, 56, 0, 0);
$letters[80] = array( 0, 252, 102, 102, 102, 124, 96, 96, 96, 240, 0, 0);
$letters[81] = array( 0, 56, 108, 198, 198, 198, 206, 222, 124, 12, 30, 0);
$letters[82] = array( 0, 252, 102, 102, 102, 124, 108, 102, 102, 230, 0, 0);
$letters[83] = array( 0, 120, 204, 204, 192, 112, 24, 204, 204, 120, 0, 0);
$letters[84] = array( 0, 252, 180, 48, 48, 48, 48, 48, 48, 120, 0, 0);
$letters[85] = array( 0, 204, 204, 204, 204, 204, 204, 204, 204, 120, 0, 0);
$letters[86] = array( 0, 204, 204, 204, 204, 204, 204, 204, 120, 48, 0, 0);
$letters[87] = array( 0, 198, 198, 198, 198, 214, 214, 108, 108, 108, 0, 0);
$letters[88] = array( 0, 204, 204, 204, 120, 48, 120, 204, 204, 204, 0, 0);
$letters[89] = array( 0, 204, 204, 204, 204, 120, 48, 48, 48, 120, 0, 0);
$letters[90] = array( 0, 254, 206, 152, 24, 48, 96, 98, 198, 254, 0, 0);
$letters[91] = array( 0, 60, 48, 48, 48, 48, 48, 48, 48, 60, 0, 0);
$letters[92] = array( 0, 0, 128, 192, 96, 48, 24, 12, 6, 2, 0, 0);
$letters[93] = array( 0, 60, 12, 12, 12, 12, 12, 12, 12, 60, 0, 0);
$letters[94] = array( 16, 56, 108, 198, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[95] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0);
$letters[96] = array( 48, 48, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[97] = array( 0, 0, 0, 0, 120, 12, 124, 204, 204, 118, 0, 0);
$letters[98] = array( 0, 224, 96, 96, 124, 102, 102, 102, 102, 220, 0, 0);
$letters[99] = array( 0, 0, 0, 0, 120, 204, 192, 192, 204, 120, 0, 0);
$letters[100] = array( 0, 28, 12, 12, 124, 204, 204, 204, 204, 118, 0, 0);
$letters[101] = array( 0, 0, 0, 0, 120, 204, 252, 192, 204, 120, 0, 0);
$letters[102] = array( 0, 56, 108, 96, 96, 248, 96, 96, 96, 240, 0, 0);
$letters[103] = array( 0, 0, 0, 0, 118, 204, 204, 204, 124, 12, 204, 120);
$letters[104] = array( 0, 224, 96, 96, 108, 118, 102, 102, 102, 230, 0, 0);
$letters[105] = array( 0, 24, 24, 0, 120, 24, 24, 24, 24, 126, 0, 0);
$letters[106] = array( 0, 12, 12, 0, 60, 12, 12, 12, 12, 204, 204, 120);
$letters[107] = array( 0, 224, 96, 96, 102, 108, 120, 108, 102, 230, 0, 0);
$letters[108] = array( 0, 120, 24, 24, 24, 24, 24, 24, 24, 126, 0, 0);
$letters[109] = array( 0, 0, 0, 0, 252, 214, 214, 214, 214, 198, 0, 0);
$letters[110] = array( 0, 0, 0, 0, 248, 204, 204, 204, 204, 204, 0, 0);
$letters[111] = array( 0, 0, 0, 0, 120, 204, 204, 204, 204, 120, 0, 0);
$letters[112] = array( 0, 0, 0, 0, 220, 102, 102, 102, 102, 124, 96, 240);
$letters[113] = array( 0, 0, 0, 0, 118, 204, 204, 204, 204, 124, 12, 30);
$letters[114] = array( 0, 0, 0, 0, 236, 110, 118, 96, 96, 240, 0, 0);
$letters[115] = array( 0, 0, 0, 0, 120, 204, 96, 24, 204, 120, 0, 0);
$letters[116] = array( 0, 0, 32, 96, 252, 96, 96, 96, 108, 56, 0, 0);
$letters[117] = array( 0, 0, 0, 0, 204, 204, 204, 204, 204, 118, 0, 0);
$letters[118] = array( 0, 0, 0, 0, 204, 204, 204, 204, 120, 48, 0, 0);
$letters[119] = array( 0, 0, 0, 0, 198, 198, 214, 214, 108, 108, 0, 0);
$letters[120] = array( 0, 0, 0, 0, 198, 108, 56, 56, 108, 198, 0, 0);
$letters[121] = array( 0, 0, 0, 0, 102, 102, 102, 102, 60, 12, 24, 240);
$letters[122] = array( 0, 0, 0, 0, 252, 140, 24, 96, 196, 252, 0, 0);
$letters[123] = array( 0, 28, 48, 48, 96, 192, 96, 48, 48, 28, 0, 0);
$letters[124] = array( 0, 24, 24, 24, 24, 0, 24, 24, 24, 24, 0, 0);
$letters[125] = array( 0, 224, 48, 48, 24, 12, 24, 48, 48, 224, 0, 0);
$letters[126] = array( 0, 115, 218, 206, 0, 0, 0, 0, 0, 0, 0, 0);
$letters[127] = array( 0, 0, 0, 16, 56, 108, 198, 198, 254, 0, 0, 0);
$letters[128] = array( 0, 120, 204, 204, 192, 192, 192, 204, 204, 120, 48, 240);
$letters[129] = array( 0, 204, 204, 0, 204, 204, 204, 204, 204, 118, 0, 0);
$letters[130] = array( 12, 24, 48, 0, 120, 204, 252, 192, 204, 120, 0, 0);
$letters[131] = array( 48, 120, 204, 0, 120, 12, 124, 204, 204, 118, 0, 0);
$letters[132] = array( 0, 204, 204, 0, 120, 12, 124, 204, 204, 118, 0, 0);
$letters[133] = array( 192, 96, 48, 0, 120, 12, 124, 204, 204, 118, 0, 0);
$letters[134] = array( 56, 108, 108, 56, 248, 12, 124, 204, 204, 118, 0, 0);
$letters[135] = array( 0, 0, 0, 0, 120, 204, 192, 192, 204, 120, 48, 240);
$letters[136] = array( 48, 120, 204, 0, 120, 204, 252, 192, 192, 124, 0, 0);
$letters[137] = array( 0, 204, 204, 0, 120, 204, 252, 192, 192, 124, 0, 0);
$letters[138] = array( 192, 96, 48, 0, 120, 204, 252, 192, 192, 124, 0, 0);
$letters[139] = array( 0, 108, 108, 0, 120, 24, 24, 24, 24, 126, 0, 0);
$letters[140] = array( 16, 56, 108, 0, 120, 24, 24, 24, 24, 126, 0, 0);
$letters[141] = array( 96, 48, 24, 0, 120, 24, 24, 24, 24, 126, 0, 0);
$letters[142] = array( 0, 204, 0, 48, 120, 204, 204, 252, 204, 204, 0, 0);
$letters[143] = array( 120, 204, 204, 120, 120, 204, 204, 252, 204, 204, 0, 0);
$letters[144] = array( 12, 24, 48, 252, 196, 192, 248, 192, 196, 252, 0, 0);
$letters[145] = array( 0, 0, 0, 0, 254, 27, 127, 216, 216, 239, 0, 0);
$letters[146] = array( 0, 62, 120, 216, 216, 254, 216, 216, 216, 222, 0, 0);
$letters[147] = array( 48, 120, 204, 0, 120, 204, 204, 204, 204, 120, 0, 0);
$letters[148] = array( 0, 204, 204, 0, 120, 204, 204, 204, 204, 120, 0, 0);
$letters[149] = array( 192, 96, 48, 0, 120, 204, 204, 204, 204, 120, 0, 0);
$letters[150] = array( 48, 120, 204, 0, 204, 204, 204, 204, 204, 118, 0, 0);
$letters[151] = array( 192, 96, 48, 0, 204, 204, 204, 204, 204, 118, 0, 0);
$letters[152] = array( 0, 102, 102, 0, 102, 102, 102, 102, 60, 12, 24, 240);
$letters[153] = array( 204, 0, 120, 204, 204, 204, 204, 204, 204, 120, 0, 0);
$letters[154] = array( 204, 0, 204, 204, 204, 204, 204, 204, 204, 120, 0, 0);
$letters[155] = array( 0, 48, 48, 120, 204, 192, 192, 204, 120, 48, 48, 0);
$letters[156] = array( 60, 102, 96, 96, 96, 252, 96, 96, 192, 254, 0, 0);
$letters[157] = array( 204, 204, 204, 204, 120, 252, 48, 252, 48, 48, 0, 0);
$letters[158] = array( 240, 136, 136, 136, 240, 136, 158, 140, 141, 134, 0, 0);
$letters[159] = array( 14, 27, 24, 24, 126, 24, 24, 24, 216, 112, 0, 0);
$letters[160] = array( 12, 24, 48, 0, 120, 12, 124, 204, 204, 118, 0, 0);
$letters[161] = array( 12, 24, 48, 0, 120, 24, 24, 24, 24, 126, 0, 0);
$letters[162] = array( 12, 24, 48, 0, 120, 204, 204, 204, 204, 120, 0, 0);
$letters[163] = array( 12, 24, 48, 0, 204, 204, 204, 204, 204, 118, 0, 0);
$letters[164] = array( 0, 118, 220, 0, 248, 204, 204, 204, 204, 204, 0, 0);
$letters[165] = array( 118, 220, 0, 198, 230, 246, 222, 206, 198, 198, 0, 0);
$letters[166] = array( 0, 120, 204, 204, 126, 0, 254, 0, 0, 0, 0, 0);
$letters[167] = array( 0, 120, 204, 204, 120, 0, 254, 0, 0, 0, 0, 0);
$letters[168] = array( 0, 48, 48, 0, 48, 96, 192, 192, 204, 120, 0, 0);
$letters[169] = array( 0, 0, 0, 0, 0, 252, 192, 192, 192, 0, 0, 0);
$letters[170] = array( 0, 0, 0, 0, 0, 252, 12, 12, 12, 0, 0, 0);
$letters[171] = array( 0, 66, 198, 204, 216, 48, 110, 195, 134, 12, 31, 0);
$letters[172] = array( 0, 99, 230, 108, 120, 55, 111, 219, 179, 63, 3, 0);
$letters[173] = array( 0, 48, 48, 0, 48, 48, 120, 120, 120, 48, 0, 0);
$letters[174] = array( 0, 0, 0, 0, 51, 102, 204, 204, 102, 51, 0, 0);
$letters[175] = array( 0, 0, 0, 0, 204, 102, 51, 51, 102, 204, 0, 0);
$letters[176] = array( 36, 146, 73, 36, 146, 73, 36, 146, 73, 36, 146, 73);
$letters[177] = array( 85, 170, 85, 170, 85, 170, 85, 170, 85, 170, 85, 170);
$letters[178] = array( 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182);
$letters[179] = array( 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24);
$letters[180] = array( 24, 24, 24, 24, 24, 248, 24, 24, 24, 24, 24, 24);
$letters[181] = array( 24, 24, 24, 24, 248, 24, 24, 248, 24, 24, 24, 24);
$letters[182] = array( 102, 102, 102, 102, 102, 230, 102, 102, 102, 102, 102, 102);
$letters[183] = array( 0, 0, 0, 0, 0, 254, 102, 102, 102, 102, 102, 102);
$letters[184] = array( 0, 0, 0, 0, 248, 24, 24, 248, 24, 24, 24, 24);
$letters[185] = array( 102, 102, 102, 102, 230, 6, 6, 230, 102, 102, 102, 102);
$letters[186] = array( 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102);
$letters[187] = array( 0, 0, 0, 0, 254, 6, 6, 230, 102, 102, 102, 102);
$letters[188] = array( 102, 102, 102, 102, 230, 6, 6, 254, 0, 0, 0, 0);
$letters[189] = array( 102, 102, 102, 102, 102, 254, 0, 0, 0, 0, 0, 0);
$letters[190] = array( 24, 24, 24, 24, 248, 24, 24, 248, 0, 0, 0, 0);
$letters[191] = array( 0, 0, 0, 0, 0, 248, 24, 24, 24, 24, 24, 24);
$letters[192] = array( 24, 24, 24, 24, 24, 31, 0, 0, 0, 0, 0, 0);
$letters[193] = array( 24, 24, 24, 24, 24, 255, 0, 0, 0, 0, 0, 0);
$letters[194] = array( 0, 0, 0, 0, 0, 255, 24, 24, 24, 24, 24, 24);
$letters[195] = array( 24, 24, 24, 24, 24, 31, 24, 24, 24, 24, 24, 24);
$letters[196] = array( 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0);
$letters[197] = array( 24, 24, 24, 24, 24, 255, 24, 24, 24, 24, 24, 24);
$letters[198] = array( 24, 24, 24, 24, 31, 24, 24, 31, 24, 24, 24, 24);
$letters[199] = array( 102, 102, 102, 102, 102, 103, 102, 102, 102, 102, 102, 102);
$letters[200] = array( 102, 102, 102, 102, 103, 96, 96, 127, 0, 0, 0, 0);
$letters[201] = array( 0, 0, 0, 0, 127, 96, 96, 103, 102, 102, 102, 102);
$letters[202] = array( 102, 102, 102, 102, 231, 0, 0, 255, 0, 0, 0, 0);
$letters[203] = array( 0, 0, 0, 0, 255, 0, 0, 231, 102, 102, 102, 102);
$letters[204] = array( 102, 102, 102, 102, 103, 96, 96, 103, 102, 102, 102, 102);
$letters[205] = array( 0, 0, 0, 0, 255, 0, 0, 255, 0, 0, 0, 0);
$letters[206] = array( 102, 102, 102, 102, 231, 0, 0, 231, 102, 102, 102, 102);
$letters[207] = array( 24, 24, 24, 24, 255, 0, 0, 255, 0, 0, 0, 0);
$letters[208] = array( 102, 102, 102, 102, 102, 255, 0, 0, 0, 0, 0, 0);
$letters[209] = array( 0, 0, 0, 0, 255, 0, 0, 255, 24, 24, 24, 24);
$letters[210] = array( 0, 0, 0, 0, 0, 255, 102, 102, 102, 102, 102, 102);
$letters[211] = array( 102, 102, 102, 102, 102, 127, 0, 0, 0, 0, 0, 0);
$letters[212] = array( 24, 24, 24, 24, 31, 24, 24, 31, 0, 0, 0, 0);
$letters[213] = array( 0, 0, 0, 0, 31, 24, 24, 31, 24, 24, 24, 24);
$letters[214] = array( 0, 0, 0, 0, 0, 127, 102, 102, 102, 102, 102, 102);
$letters[215] = array( 102, 102, 102, 102, 102, 231, 102, 102, 102, 102, 102, 102);
$letters[216] = array( 24, 24, 24, 24, 255, 0, 0, 255, 24, 24, 24, 24);
$letters[217] = array( 24, 24, 24, 24, 24, 248, 0, 0, 0, 0, 0, 0);
$letters[218] = array( 0, 0, 0, 0, 0, 31, 24, 24, 24, 24, 24, 24);
$letters[219] = array( 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255);
$letters[220] = array( 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255);
$letters[221] = array( 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240);
$letters[222] = array( 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15);
$letters[223] = array( 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0);
$letters[224] = array( 0, 0, 0, 0, 118, 222, 204, 204, 222, 118, 0, 0);
$letters[225] = array( 0, 120, 204, 204, 216, 204, 204, 204, 248, 192, 96, 0);
$letters[226] = array( 0, 252, 204, 204, 192, 192, 192, 192, 192, 192, 0, 0);
$letters[227] = array( 0, 254, 108, 108, 108, 108, 108, 108, 108, 102, 0, 0);
$letters[228] = array( 0, 252, 196, 100, 96, 48, 96, 100, 196, 252, 0, 0);
$letters[229] = array( 0, 0, 0, 0, 126, 200, 204, 204, 204, 120, 0, 0);
$letters[230] = array( 0, 0, 0, 0, 102, 102, 102, 102, 102, 123, 96, 192);
$letters[231] = array( 0, 0, 0, 118, 220, 24, 24, 24, 24, 14, 0, 0);
$letters[232] = array( 0, 252, 48, 120, 204, 204, 204, 120, 48, 252, 0, 0);
$letters[233] = array( 0, 120, 204, 204, 204, 252, 204, 204, 204, 120, 0, 0);
$letters[234] = array( 0, 124, 198, 198, 198, 198, 108, 108, 108, 238, 0, 0);
$letters[235] = array( 0, 60, 96, 48, 120, 204, 204, 204, 204, 120, 0, 0);
$letters[236] = array( 0, 0, 0, 118, 219, 219, 219, 110, 0, 0, 0, 0);
$letters[237] = array( 0, 0, 6, 124, 222, 214, 246, 124, 192, 0, 0, 0);
$letters[238] = array( 0, 60, 96, 192, 192, 252, 192, 192, 96, 60, 0, 0);
$letters[239] = array( 0, 0, 120, 204, 204, 204, 204, 204, 204, 204, 0, 0);
$letters[240] = array( 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 0);
$letters[241] = array( 0, 0, 48, 48, 252, 48, 48, 0, 252, 0, 0, 0);
$letters[242] = array( 0, 96, 48, 24, 24, 48, 96, 0, 252, 0, 0, 0);
$letters[243] = array( 0, 24, 48, 96, 96, 48, 24, 0, 252, 0, 0, 0);
$letters[244] = array( 0, 0, 14, 27, 27, 24, 24, 24, 24, 24, 24, 24);
$letters[245] = array( 24, 24, 24, 24, 24, 24, 24, 216, 216, 112, 0, 0);
$letters[246] = array( 0, 0, 48, 48, 0, 252, 0, 48, 48, 0, 0, 0);
$letters[247] = array( 0, 0, 115, 219, 206, 0, 115, 219, 206, 0, 0, 0);
$letters[248] = array( 0, 60, 102, 102, 102, 60, 0, 0, 0, 0, 0, 0);
$letters[249] = array( 0, 0, 0, 0, 28, 28, 0, 0, 0, 0, 0, 0);
$letters[250] = array( 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0);
$letters[251] = array( 0, 7, 4, 4, 4, 68, 100, 52, 28, 12, 0, 0);
$letters[252] = array( 0, 216, 108, 108, 108, 108, 0, 0, 0, 0, 0, 0);
$letters[253] = array( 0, 120, 12, 24, 48, 124, 0, 0, 0, 0, 0, 0);
$letters[254] = array( 0, 0, 60, 60, 60, 60, 60, 60, 60, 60, 0, 0);
$letters[255] = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
}
?>